/*
 * Decompiled with CFR 0.152.
 */
package com.kedacom.sso.atlassiansso;

import com.kedacom.sso.atlassiansso.SSOUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class KDCharacterEncodingFilter
implements Filter {
    private String encoding = "UTF-8";
    private String contentType = "text/html;charset=UTF-8";
    private String ignorePageString;
    private String[] ignorePageArr = new String[0];

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (SSOUtil.isIgnored(request, this.ignorePageArr)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        request.setCharacterEncoding(this.encoding);
        response.setCharacterEncoding(this.encoding);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void init(FilterConfig config) throws ServletException {
        String _encoding = config.getInitParameter("encoding");
        String _contentType = config.getInitParameter("contentType");
        if (_encoding != null) {
            this.encoding = _encoding;
        }
        if (_contentType != null) {
            this.contentType = _contentType;
        }
        this.setIgnorePageString(config.getServletContext().getInitParameter("ignorePageString"));
        if (!StringUtils.isEmpty((Object)this.getIgnorePageString())) {
            this.ignorePageArr = this.getIgnorePageString().split("\\,");
        }
    }

    public String getIgnorePageString() {
        return this.ignorePageString;
    }

    public void setIgnorePageString(String ignorePageString) {
        this.ignorePageString = ignorePageString;
    }
}

